#include <pads.h>
SRCFILE("help.c")

char *HelpFile[] = {
"Welcome to the OpenLook(TM) version of pads.",
"In addition to providing a look and feel that is",
"consistent with other OpenLook applications, this",
"version of pads has some features not available",
"in previous releases:",
"",
" * the X11 window manager is used to resize, move",
"   and change the stacking order of pads windows.",
" * menus can be pinned so they remain visible for",
"   frequent operations.",
" * windows are automatically configured on the screen.",
"   With resource files, you may change the default",
"   layout. See Resources below.",
" * a scrollable window is used for keyboard input.",
"",
"User Interface:",
"Under OpenLook, the mouse buttons are assigned",
"the following meanings by default:",
"",
"	left: SELECT",
"	middle: ADJUST",
"	right: MENU",
"",
"These values may be changed by setting resources",
"in your .Xdefaults file. For example, the lines:",
"",
"	*selectBtn:	<Button3> ",
"	*menuBtn:	<Button1> ",
"",
"will swap the SELECT and MENU buttons.",
"",
"Windows:",
"Each window contains a text and control region.",
"The window operators are accessible in the control",
"region, and the line operators are determined by the",
"current text selection. Horizontal and vertical",
"scrollbars are added to the text region if needed.",
"",
"Text Region:",
"Within the text region the mouse buttons are used",
"as follows:",
"",
"SELECT:	set the text selection",
"ADJUST:	adjust (expand or contract) the selection",
"MENU:	generate a menu that depends on the current",
"	selection.",
"",
"If a selection spans multiple lines, the menu generated",
"is determined by the start of the selection. If no text",
"is selected, the position of the cursor determines the",
"menu.",
"",
"Control Area:",
"Each window has a control area at the top of the",
"window.  In the control area are buttons, menubuttons,",
"and scrolling list pop-ups.",
"",
"Buttons:",
"Buttons operators are activated by pressing SELECT",
"over the button.",
"",
"Menubuttons:",
"Menubuttons look like buttons, but have a vertical",
"arrow after the label text. Moving over a menubutton",
"and invoking the MENU button, pops up the menu. If",
"the pushpin on the top of the menu is placed in the",
"hole, the menu will remain popped up after MENU button",
"is released. You may use the window manager to move",
"the menu around after the pushpin is in. With the olwm,",
"the menu may be popped down by taking the pin out of",
"the hole. If the menu is popped up, but hidden by",
"another window, you may click the MENU button on top",
"of the menubutton to raise it.",
"",
"Pushing SELECT over a menubutton invokes the default",
"menu entry. For most menus in pads, this pops up the",
"menu and puts the pushpin in the hole.",
"",
"Scolling Lists:",
"Scrolling lists are used when there are more than 13",
"entries in a menu. In the control area they look like",
"buttons, but the label text will be followed by '...'",
"Use the SELECT button to pop up the scrolling list,",
"and pull the pushpin out of the hole to pop it back",
"down. To select entries in the scrolling list, scroll",
"so the desired entry is visible and click the SELECT",
"button over it. If the scrolling list is popped up,",
"but hidden by another window, you may click SELECT on",
"the button that generates it to raise it.",
"",
"Every window contains an 'edit' menubutton. The menu",
"contains the following entries:",
"",
"send	Send the selected text in the window to the",
"	keyboard input window. This is an accelerator",
"	for selecting 'copy', moving to the keyboard",
"	window and selecting 'paste' in its menu.",
"",
"cut	Remove the selected lines from the window.",
"	Lines that are partially selected are treated",
"	as if the whole line is selected. Some windows",
"	do not allow you to edit the text.",
"",
"copy	Copy the selected text to the window system",
"	cut buffer.",
"",
"close	Close the window. If you are using the olwm,",
"	you may alternatively press the SELECT button",
"	in the abbreviated menubutton in the window",
"	header. With other window managers, iconifying",
"	the window is an equivalent operation.",
"",
"Keyboard Window:",
"The keyboard input window is used to edit and send",
"keyboard input to the selected line or window.",
"Iconifying the keyboard window iconifies the whole",
"application.",
"",
"The keyboard window's control area has a 'windows'",
"menu that allows you to access all the windows in the",
"application, and indicators to display the window and",
"line with the current keyboard focus. If the Line",
"field displays 'None', the current line does not",
"accept keyboard input. The keyboard focus is set by",
"pressing a key or selecting text in any of the other",
"pads windows.",
"",
"Text can be entered several ways:",
"",
"   * Type directly into the keyboard window",
"   * Use the 'edit' menu in the keyboard window to paste",
"     in text from other windows.",
"   * Type into any other pads window. The characters are",
"     echoed in the keyboard window.",
"   * Use the 'send' entry in the 'edit' menu of any other",
"     pads window to send the current selection.",
"",
"The text is sent to the application when carriage return",
"is inserted at the end of the window, so the keyboard",
"focus is only important when the carriage return is entered.",
"This allows a complicated expression to be grabbed from one",
"window with the mouse, and then sent to a second window by",
"moving the cursor into the second window before typing the",
"carriage return.",
"",
"The following keyboard sequences have special meaning:",
"",
" ?		Each window or line that accepts keyboard",
"		input displays help in response.",
"",
" <shell_cmd	runs the given command and uses its standard",
"		output as the keyboard input.",
"",
" >shell_cmd	runs the given command using the contents of",
"		the selected line or window as the standard",
"		input.",
"",
"Resources:",
"The default pads resources for pi and rtpi are shown below.",
"You may override these values by placing entries in your",
"resource database (usually $HOME/.Xdefaults) or by",
"installing a resource defaults file named Pads in the X11",
"app-defaults directory.",
"",
#ifdef sun
"assembler.geometry:		275x400+673+445",
"breakpoint.geometry:		150x175+980+225",
"frame.geometry:			350x175+460+225",
"globals.geometry:		350x175+460+225",
"journal.geometry:		500x160+480+20",
"keyboard.geometry:		400x125+40+65",
"memory.geometry:		200x200+940+667",
"pi.geometry:			500x160+460+30",
"process.geometry:		400x175+40+225",
"rtconnect.geometry:		500x160+480+20",
"rtpi.geometry:			500x160+460+30",
"signals.geometry:		200x200+940+435",
"source.geometry:		600x400+40+435",
"srcfiles.geometry:		140x175+825+225",
"usertypes.geometry:		275x400+653+435",
"help*charsVisible:		65",
"help*linesVisible:		15",
"wd*linesVisible:		4",
"TopLevelShell*Background:	grey80",
"TopLevelShell*TextBackground:	white",
"TopLevelShell*Caption.font:	lucidasans-bold",
"TopLevelShell*font:		lucidasanstypewriter",
"*blinkRate:			0",
#endif
#ifdef sgi
"assembler.geometry:		275x400+683+495",
"breakpoint.geometry:		170x175+1000+265",
"frame.geometry:			350x175+460+265",
"globals.geometry:		350x175+460+265",
"journal.geometry:		500x160+480+50",
"keyboard.geometry:		400x125+40+95",
"memory.geometry:		200x200+960+727",
"pi.geometry:			500x160+460+60",
"process.geometry:		400x175+40+265",
"rtconnect.geometry:		500x160+480+50",
"rtpi.geometry:			500x160+460+60",
"signals.geometry:		200x200+960+485",
"source.geometry:		600x400+40+485",
"srcfiles.geometry:		140x175+835+265",
"usertypes.geometry:		275x400+663+485",
"help*charsVisible:		65",
"help*linesVisible:		15",
"wd*linesVisible:		4",
"TopLevelShell*Background:	grey70",
"TopLevelShell*TextBackground:	midnight blue",
"TopLevelShell*TextEdit.TextFontColor:	grey80",
"TopLevelShell*Caption.font:	screen13",
"TopLevelShell*TextEdit.font:	screen15",
"TopLevelShell*font:		screen-bold13",
"*blinkRate:			0",
#endif
#ifdef i386
"assembler.geometry:		235x250-7+330",
"breakpoint.geometry:		235x250-7+330",
"frame.geometry:			325x110-7+180",
"globals.geometry:		325x110-7+180",
"journal.geometry:		235x250-7+330",
"keyboard.geometry:		325x110-7+31",
"memory.geometry:		235x250-7+330",
"pi.geometry:			425x110+18+31",
"process.geometry:		425x110+8+31",
"rtconnect.geometry:		425x110+8+31",
"rtpi.geometry:			425x110+18+31",
"signals.geometry:		235x250-7+330",
"source.geometry:		435x395+8+180",
"srcfiles.geometry:		235x250-7+330",
"usertypes.geometry:		235x250-7+330",
"help*charsVisible:		65",
"help*linesVisible:		15",
"wd*linesVisible:		4",
"TopLevelShell*Background:	grey",
"TopLevelShell*TextBackground:	orange",
"TopLevelShell*font:		fixed",
"TopLevelShell*Caption.font:	fixed",
"*blinkRate:			0",
#endif
"",
"DAK 1/8/92",
0 };

class Help : public PadRcv {
	Pad	*pad;
	int	lines;
	void	linereq(long,Attrib=0);
public:
		Help();
	int	topic(char*);
};

static Help *shelp;

int helptopic(char *s)	{ return shelp->topic(s); }

Help::Help()
{
	trace( "%d.Help()", this );
	for( lines = 1; HelpFile[lines]; ++lines ) {}
	pad = new Pad( (PadRcv*) this );
	pad->lines(lines);
	pad->options(TRUNCATE);
	pad->banner( "Help:" );
	pad->name( "help" );
}

int Help::topic(char *t)
{
	if (!strcmp(t, "Openlook")) {
		pad->makecurrent();
		linereq(1, SELECTLINET);
		return 1;
	}
	return 0;
}

void Help::linereq(long l, Attrib a)
{
	trace( "%d.linereq(%d)", this, l );
	if( l>=1 && l<=lines )
		pad->insert( l, a, HelpFile[l-1] );
}

void NewHelp()	{ shelp = new Help; }
